Imports ComponentPro

Namespace AdvancedDemo.Samples.Function_and_Property
	Public NotInheritable Class MyTestClass

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestString() As String
			Get
				Return "Static String"
			End Get
		End Property
		Public Shared Function GetStaticString(ByVal s As String) As String
			Return String.Format("GetStaticString returns {0}", s)
		End Function
	End Class
	Public NotInheritable Class ClassRestricted

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestString() As String
			Get
				Return "Test String in a restricted class"
			End Get
		End Property
	End Class
	Public NotInheritable Class MethodAndProperty

		Private Sub New()
		End Sub

		Public Shared ReadOnly Property TestStringRestricted() As String
			Get
				Return "Restricted String"
			End Get
		End Property
		Public Shared Function GetStaticStringRestricted(ByVal s As String) As String
			Return String.Format("GetStaticStringRestricted returns {0}", s)
		End Function
		Public Shared ReadOnly Property StaticStringAllowed() As String
			Get
				Return "StaticStringAllowed"
			End Get
		End Property
	End Class

	Friend Class Calling_Restriction
		Inherits TemplateExampleBase
		''' <summary>
		''' Generates output from a template file.
		''' </summary>
		''' <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
		''' <param name="templateFile">The template file path.</param>
		''' <param name="templateSource">The template source loaded from the template file.</param>
		''' <returns>The generated output.</returns>
		Public Overrides Function Generate(ByVal templateSourceDirectory As String, ByVal templateFile As String, ByVal templateSource As String) As String
			' Create a new instance of the TemplateEngine class.
			Dim dt As New TemplateEngine()

			' Load template content from a file.
			dt.LoadFromString(templateSource)
			dt.SetValue("TemplateSourceDirectory", templateSourceDirectory)

			Dim mybook As New Book()
			dt.SetValue("bk", mybook)

			dt.UsingNamespace("AdvancedDemo.Samples.Function_and_Property,AdvancedDemo")

			dt.RestrictedMethodList.Add("*.ClassRestricted.*")
			dt.RestrictedPropertyList.Add("*.ClassRestricted.*")
			dt.RestrictedMethodList.Add("*.MethodAndProperty.GetStaticString*")
			dt.AllowedMethodList.Add("*.MethodAndProperty.GetStaticStringAllowed")
			dt.RestrictedPropertyList.Add("*.TestStringRestricted")

			' Generate output.
			Dim output As String = dt.Run()

			Return output
		End Function
	End Class
End Namespace
